from flask import Flask, render_template
from pyHS100 import SmartPlug
from pyHS100 import Discover

app = Flask(__name__)

 
@app.route("/")
def pi_plug(): 
     piswitch = []
     for dev in Discover.discover().values():
         piswitch += [dev]       
     return render_template('index.html', piswitch=piswitch) 
 

@app.route('/piswitch/on/<name>')
def led_on(name):
     myipaddress = name
     plug = SmartPlug(myipaddress)
     plug.turn_on()
     return render_template('page.html', name=name)
 
 
@app.route('/piswitch/off/<name>')
def led_off(name):
     myipaddress = name
     plug = SmartPlug(myipaddress)
     plug.turn_off()
     return render_template('page.html', name=name)     


if __name__ == '__main__':
    app.run(debug=True, port=5000, host='0.0.0.0')